function [matrix,fmatrix]=make_retstim(stim_param,disp_param,fmri_param);
% [matrix,fmatrix]=make_retstim(stim_param,disp_param,fmri_param);

if nargin < 3,
	help(mfilename);
	return;
end;

% Make matrix coordinate system with 0 in center:
coords=-disp_param.matrixsize/2+.5:disp_param.matrixsize/2-.5;
[xx,yy]=meshgrid(coords);
pol = fliplr(angle(xx.*i+yy))+ones(size(xx)).*pi;
ecc = sqrt((xx.*xx)+(yy.*yy));
ecc = ecc./(disp_param.matrixsize/2);
clear xx yy coords;

if sum(stim_param.fixoffset)~=0,
	offset=stim_param.fixoffset*(disp_param.matrixsize/stim_param.stimsize);
	Cx=-disp_param.matrixsize/2+.5-offset(1):disp_param.matrixsize/2-.5-offset(1);
	Cy=-disp_param.matrixsize/2+.5+offset(2):disp_param.matrixsize/2-.5+offset(2);
	[xx,yy]=meshgrid(Cx,Cy);
	eccf = sqrt((xx.*xx)+(yy.*yy));
	eccf = eccf./(disp_param.matrixsize/2);
	clear xx yy Cx Cy;
else,
	eccf=ecc;
end;

fix_ecc1  = find(eccf <= disp_param.fix/2);
fix_ecc2  = find(eccf <= disp_param.fix);
stim_ecc  = find(ecc >= disp_param.ecc(1) & ecc <= disp_param.ecc(2));
nstim_ecc = find(ecc <= disp_param.ecc(1) | ecc >= disp_param.ecc(2));

if disp_param.target_fix,
	fsize=round(disp_param.fix*disp_param.matrixsize);
	[xx(:,:,1),xx(:,:,2)]=meshgrid(-fsize/2+.5:fsize/2-.5);
	fecc = mean(abs(xx),3);
	fecc2= sqrt((xx(:,:,1).^2)+(xx(:,:,2).^2))./(fsize/2);
	clear xx yy;
	fmatrix=ones(fsize).*0;
	fmatrix(fecc2<=1)=1;
	fmatrix(fecc(:,1:round(fsize/2)) < fsize/4)=2;
	fmatrix(round(fsize/6*3):round(fsize/6*4),round(fsize/2):end-1)=2;	
	fmatrix(:,:,2)=fliplr(fmatrix);
else,
	fmatrix=[];
end;

nMRframesPerCycle = (fmri_param.ntimeframes-fmri_param.nblanks)/...
					stim_param.fundamental_freq;

nStimFramesPerCycle = nMRframesPerCycle*fmri_param.tr*stim_param.stepfreq;
stepsize.pol=2*pi/nStimFramesPerCycle;
stepsize.ecc=(disp_param.ecc(2)-disp_param.ecc(1))/nStimFramesPerCycle;
disp(sprintf('Discrete steps in polar-angle  dimension: %0.2f degrees.',stepsize.pol/(2*pi)*360));
disp(sprintf('Discrete steps in eccentricity dimension: %0.2f degrees.',stepsize.ecc.*stim_param.stimsize));

image_matrix=zeros(disp_param.matrixsize,disp_param.matrixsize,nStimFramesPerCycle);

if stim_param.whichstim=='p',
	pol=phaseshift(pol,stim_param.wedgeangle/2+stepsize.pol);%start in middle up
	fprintf('Processing:');drawnow;
	for n1=1:nStimFramesPerCycle,
		tmp_matrix1=ecc.*0;%image_matrix(:,:,1).*0;
		pol=phaseshift(pol,-stepsize.pol);
		inwedge=find(pol >= 0 & pol <= stim_param.wedgeangle);
		tmp_matrix1(inwedge)=round((pol(inwedge)-min(min(pol(inwedge))))./max(max(pol(inwedge))).*...
								stim_param.nchecks+.5);
		tmp_matrix1(inwedge)=tmp_matrix1(inwedge)+round(ecc(inwedge).*stim_param.eccrange+.5).*stim_param.nchecks;
		tmp_matrix1(inwedge)=tmp_matrix1(inwedge)+10;
		tmp_matrix1(nstim_ecc)=0;
	 	tmp_matrix1(fix_ecc2)=1;
		tmp_matrix1(fix_ecc1)=2;
		
		image_matrix(:,:,n1)=tmp_matrix1;
		fprintf('.');drawnow;
	end;
	fprintf('Done.\n');drawnow;
else,
	fprintf('Processing:');drawnow;
	for n1=1:nStimFramesPerCycle,
		tmp_matrix1=ecc.*0;%image_matrix(:,:,1).*0;
		circle=find(ecc>=disp_param.ecc(1)+(n1-1)*stepsize.ecc & ecc<disp_param.ecc(1)+stim_param.eccwidth+(n1-1)*stepsize.ecc);
		tmp_matrix1(circle)=round(pol(circle)./(2*pi).*20+.5);
		tmp_matrix1(circle)=tmp_matrix1(circle)+20*round((ecc(circle)-disp_param.ecc(1)-(n1-1)*stepsize.ecc)./stim_param.eccwidth.*2+.5);
		tmp_matrix1(circle)=tmp_matrix1(circle)+10;
		% wrap around
		if disp_param.ecc(1)+stim_param.eccwidth+(n1-1)*stepsize.ecc > 1,
			diff=disp_param.ecc(1)+stim_param.eccwidth+(n1-1)*stepsize.ecc-1;
			circle=find(ecc>=disp_param.ecc(1) & ecc<disp_param.ecc(1)+diff);
			tmp_matrix1(circle)=round(pol(circle)./(2*pi).*20+.5);
			tmp_matrix1(circle)=tmp_matrix1(circle)+20*round((ecc(circle)-disp_param.ecc(1))./...
																stim_param.eccwidth.*2+.5);
			tmp_matrix1(circle)=tmp_matrix1(circle)+10;
		end;
		tmp_matrix1(nstim_ecc)=0;
	 	tmp_matrix1(fix_ecc2)=1;
		tmp_matrix1(fix_ecc1)=2;
		
		image_matrix(:,:,n1)=tmp_matrix1;
		fprintf('.');drawnow;
	end;
	fprintf('Done.\n');drawnow;
end;

matrix=uint8(image_matrix);

%%%---------------
function [mymatrix]=phaseshift(mymatrix,shift);

mymatrix=mymatrix+shift;
over=find(mymatrix>2*pi);
mymatrix(over)=mymatrix(over)-2*pi;
under=find(mymatrix<0);
mymatrix(under)=mymatrix(under)+2*pi;

