function [results]=retstim(matname,runpsych);
% RETSTIM - retinotopic mapping stimulus

% clean up

if nargin < 1 | isempty(matname),
	matname='test';
end;
if nargin < 2,
	runpsych=0;
end;




while(exist([matname '.mat'],'file')~=0),
	ans=input(sprintf('\n\n%s exists, please give new name ([return]=clobber): ',matname),'s');
	if isempty(deblank(ans)),
		break;
	else, 
		matname=deblank(ans);
	end;
end;
clear input;

arg_param.matname=matname;
arg_param.runpsych=runpsych;
clear matname runpsych;

%--- random seed and loading mex and other stuff
clear screens; %just in case
clear mex;
rand('state',sum(100*clock));
	
%----------------------------------------------------------
%--- get params
%----------------------------------------------------------
[stim_param,disp_param,fmri_param]=retstim_params;
if ~arg_param.runpsych,
	fmri_param.rbutton=fmri_param.rbutton([3 4 1 2]);
end;

%--- some calibration stuff
%params=grncal2gamma;
clut=[0:255]'*[1 1 1];

%----------------------------------------------------------
%--- make stimulus
%----------------------------------------------------------
[disp_param.stimulus disp_param.fixation]=make_retstim(stim_param,disp_param,fmri_param);

vals=unique(double(disp_param.stimulus(:,:,1)));
disp_param.indexes = vals(4:end)+1;
disp_param.target_rows_index = reshape(disp_param.indexes,...
								length(disp_param.indexes)./disp_param.target_rows,...
								disp_param.target_rows)';

% hardcode for now
if stim_param.whichstim=='p',
	disp_param.target=[255 0 255 0 0 255 0 255]'*[1 1 1];
elseif stim_param.whichstim=='e',
	tmp=disp_param.target_rows_index;
	tmp(1,:)=[disp_param.target_rows_index(1,1:5) disp_param.target_rows_index(3,1:5)];
	tmp(2,:)=[disp_param.target_rows_index(1,6:10) disp_param.target_rows_index(3,6:10)];
	tmp(3,:)=[disp_param.target_rows_index(2,1:5) disp_param.target_rows_index(4,1:5)];
	tmp(4,:)=[disp_param.target_rows_index(2,6:10) disp_param.target_rows_index(4,6:10)];
	disp_param.target_rows_index=tmp;
	disp_param.target=[255 0 255 0 255 0 255 0 255 0]'*[1 1 1];
end;
for n=2:6,
	disp_param.target(:,:,n)=disp_param.target(:,:,1);
end;
for n=1:size(disp_param.target,1),
	if(disp_param.target(n,1,2)==255),
		disp_param.target(n,:,2)=[255 0 0];
		disp_param.target(n,:,3)=[255 255 0];
		disp_param.target(n,:,4)=[0 0 255];
		disp_param.target(n,:,5)=[0 255 0];
		disp_param.target(n,:,6)=[0 0 0];
	elseif(disp_param.target(n,1,2)==0),
		disp_param.target(n,:,2)=[0 255 0];
		disp_param.target(n,:,3)=[0 0 255];
		disp_param.target(n,:,4)=[255 255 0];
		disp_param.target(n,:,5)=[255 0 0];
		disp_param.target(n,:,6)=[255 255 255];
	end;
end;
	

%----------------------------------------------------------------------
%--- showstuff
%----------------------------------------------------------------------
clear mex;
[sync_param]=showstuff_retstim(disp_param,stim_param,fmri_param,arg_param);

%----------------------------------------------------------------------
%--- save all
%----------------------------------------------------------------------
disp_param.stimulus=[];%to save space
disp_param.fixation=[];
save(arg_param.matname,'disp_param','stim_param','fmri_param','sync_param','arg_param');

%----------------------------------------------------------------------
%--- evaluate subjects performance
%----------------------------------------------------------------------
target=find(sync_param.response==1);
if isempty(target),
	disp(sprintf('NO TARGETS FOUND'));
	return;
end;
response=find(sync_param.response>=min(double(fmri_param.rbutton)) &...
			  sync_param.response<=max(double(fmri_param.rbutton)));%keys 1 to 4
if isempty(response),
	disp(sprintf('NO RESPONSES FOUND'));
	return;
end;
triggers=find(sync_param.response==double(fmri_param.tbutton));
if isempty(triggers),
	disp(sprintf('NO TRIGGERS FOUND'));
	return;
end;
target_exposure=[sync_param.resptime(target) sync_param.resptime(target)+disp_param.target_duration/stim_param.tempfreq]';
count=0;
tmp=[];
for n=1:size(target,1),
	tmp=find(sync_param.resptime(response)>=sync_param.resptime(target(n)) & ...
		     sync_param.resptime(response)<=sync_param.resptime(target(n)) + ...
			 disp_param.target_duration/stim_param.tempfreq);
	if ~isempty(tmp),
        count=count+1;
		target_exposure(2,n)=sync_param.resptime(response(tmp(1)));
	end;
end;
sync_param.ntargets=length(target);
sync_param.pc=count./length(target)*100;


figure(1);clf;
plot(target_exposure,...
	  [1;1]*ones(size(sync_param.resptime(target)))','b');hold on;
plot(sync_param.resptime(response),ones(1,length(response)),'ro');
plot([sync_param.resptime(triggers) sync_param.resptime(triggers)]',...
     [ones(1,length(triggers))*.9; ones(1,length(triggers))],'g');
k=axis;
axis([k(1:3) 1.1]);

target_exposure_time=target_exposure(2,:)-target_exposure(1,:);
rc=mean(target_exposure_time(find(target_exposure_time<disp_param.target_duration/stim_param.tempfreq)));

sync_param.rc=rc;
disp(sprintf('Percent correct = %.1f%% [%d targets], reaction time (when correct): %.2fsecs',sync_param.pc,length(target),rc));
title(sprintf('percent correct = %.1f%% [%d targets], reaction time (when correct): %.2fsecs',sync_param.pc,length(target),rc));


%----------------------------------------------------------------------
%--- save all
%----------------------------------------------------------------------
save(arg_param.matname,'disp_param','stim_param','fmri_param','sync_param','arg_param');






