function [stim_param,disp_param,fmri_param]=retstim_params;

whichstim=0;
fprintf('Which kind of stimulus presentation, [e]ccentricity or [p]olar-angle? ');
while(1), %also call all mex functions used later
	if charavail,
		whichstim=getchar;
		getsecs;
	end;
	if whichstim=='p',
		disp(sprintf('POLAR-ANGLE'));
		break;
	elseif whichstim=='e',
		disp(sprintf('ECCENTRICITY'));
		break;
	end;
end;
stim_param.whichstim=whichstim;

reverse_order=0;
fprintf('Present in [n]ormal or [r]everse order? ');
while(1), %also call all mex functions used later
	if charavail,
		reverse_order=getchar;
		getsecs;
	end;
	if reverse_order=='r',
		disp(sprintf('REVERSE'));
		break;
	elseif reverse_order=='n',
		disp(sprintf('NORMAL'));
		break;
	end;
end;
stim_param.reverse_order=reverse_order;

stim_param.stimsize  = 34;
r  = input(sprintf('Stimulus size in degrees [%d]?: ',stim_param.stimsize));
if ~isempty(r),
	stim_param.stimsize=r;
end;
disp(sprintf('Stimulus size = %d degrees.',stim_param.stimsize));

stim_param.fixoffset = [0; 0];
r = input(sprintf('Horizontal fixation dot offset in degrees [%.1f]?: ',stim_param.fixoffset(1)));
if ~isempty(r),
	stim_param.fixoffset(1)=r;
end;
r = input(sprintf('Vertical   fixation dot offset in degrees [%.1f]?: ',stim_param.fixoffset(2)));
if ~isempty(r),
	stim_param.fixoffset(2)=r;
end;
disp(sprintf('Fixation dot offset: [horizontal, vertical] = [%0.1f, %0.1f] degrees.',stim_param.fixoffset));

fixstim=0;
fprintf('Stimulate central 2 degrees (fixation dot) [y/n]? ');
while(1),
	if charavail,
		fixstim=getchar;
		getsecs;
	end;
	if fixstim=='y',
		disp(sprintf('YES'));
		stim_param.fixstim=1;
		break;
	elseif fixstim=='n',
		disp(sprintf('NO'));
		stim_param.fixstim=0;
		break;
	end;
end;



%----------------------------------------------------------
%--- stimulus parameters
%----------------------------------------------------------
stim_param.tempfreq    =  16;%Hz
stim_param.bgindex     =  1;
stim_param.wedgeangle  =  80/360*2*pi;%rad
stim_param.eccwidth    =  .0882*1.5;%% .*stim_param.stimsize = 3 degrees
stim_param.eccrange    =  8;% checks
stim_param.fundamental_freq = 6;
stim_param.stepfreq    = 1; %Hz
stim_param.nchecks     = 4;

%----------------------------------------------------------
%--- display parameters
%----------------------------------------------------------
disp_param.whichscreen =  0; 
disp_param.framerate   = framerate(disp_param.whichscreen); 
if(disp_param.framerate<=10),
	disp(sprintf('Invalid framerate (%.2f) -> set to 75Hz',disp_param.framerate));
	disp_param.framerate=75;
else,
	disp(sprintf('Framerate = %.2f Hz.',disp_param.framerate));
end;
disp_param.matrixsize  =512; 
disp(sprintf('Display resolution: 1 pixel = %.2f degrees.',stim_param.stimsize/disp_param.matrixsize));
disp_param.nframes     = round((1/stim_param.tempfreq) * disp_param.framerate);
disp_param.nframesstep = round((1/stim_param.stepfreq) * disp_param.framerate);
disp_param.meanlum     =128;
disp_param.ecc         = [.0625/2 1];%if(34/2 degrees 1 degree is 0.0625)
disp_param.fix         = .0312/2;
disp_param.stimrange   =[1+3:256-3];

disp_param.gclut=[0:255]'*[1 1 1].*0+1*disp_param.meanlum;
disp_param.gclut(3,:)=[0 0 0];
disp_param.gclut(2,:)=[0 0 0];
disp_param.gclut(1,:)=[1 1 1]*disp_param.meanlum;

disp_param.zclut=[0:255]'*[1 1 1].*0;

disp_param.target_rows = 4;%hard coded
disp_param.target_rows_index = [];
disp_param.target_duration = 3*stim_param.tempfreq;%3 secs * nr video frames
disp_param.target_fix  = 0; % fixation arrow task
disp_param.target_fixdiscim = 1; %check l/r
disp_param.target_stim = 1; % wedge/ring target detection task


%----------------------------------------------------------
%--- fmri parameters
%----------------------------------------------------------
fmri_param.rbutton		  =strvcat('1','2','3','4'); %left right
fmri_param.tbutton		  ='5';%trigger !
fmri_param.qbutton        ='q';
fmri_param.ntimeframes    =128;
fmri_param.nblanks        =  8;
fmri_param.tr             =  3;%secs
fmri_param.spf		      =  fmri_param.tr*stim_param.stepfreq;
fmri_param.wftrig         = repmat([1; zeros(fmri_param.spf-1,1)],fmri_param.ntimeframes*fmri_param.spf,1);
fmri_param.timeperstim    = fmri_param.tr./fmri_param.spf; %secs 
if(stim_param.reverse_order=='r'),
	fmri_param.stimseq		  = repmat([1:(fmri_param.ntimeframes-fmri_param.nblanks)/stim_param.fundamental_freq*fmri_param.spf]',...
								stim_param.fundamental_freq,1);
	fmri_param.stimseq        =flipud(fmri_param.stimseq);
	fmri_param.stimseq		  = [flipud(round([0:fmri_param.nblanks*fmri_param.spf-1]'/(fmri_param.nblanks*fmri_param.spf-1)...
								*(max(fmri_param.stimseq-fmri_param.spf-1))+1));...
								fmri_param.stimseq];
else,
	fmri_param.stimseq		  = repmat([1:(fmri_param.ntimeframes-fmri_param.nblanks)/stim_param.fundamental_freq*fmri_param.spf]',...
								stim_param.fundamental_freq,1);
	fmri_param.stimseq		  = [round([0:fmri_param.nblanks*fmri_param.spf-1]'/(fmri_param.nblanks*fmri_param.spf-1)...
								*(max(fmri_param.stimseq-fmri_param.spf-1))+1);...
								fmri_param.stimseq];
end;	
fmri_param.owtrig		  =	fmri_param.stimseq([1:fmri_param.ntimeframes]*fmri_param.spf-(fmri_param.spf-1));
fmri_param.taskthresh	  = 0.01;

if stim_param.fixstim==1,
	fmri_param.fixseq=repmat([1 1 1 1 0 0 0 0]',fmri_param.ntimeframes/8,1);
end;
