function [sync_param]=showstuff_retstim(disp_param,stim_param,fmri_param,arg_param);
% function [sync_param]=showstuff_retstim(disp_param,stim_param,fmri_param,arg_param);

if nargin < 2,
	help(mfilename);
	return;
end;

%----------------------------------------------------------
% Open screen
%----------------------------------------------------------
whichScreen   = disp_param.whichscreen;
priorityLevel = MaxPriority(whichScreen,'GetSecs','CharAvail','GetChar','SetClut');
[window,windowRect] = SCREEN(whichScreen,'OpenWindow',0,[],8);
SCREEN(window,'SetClut',disp_param.gclut);
imageRect    = SetRect(0,0,disp_param.matrixsize,disp_param.matrixsize);
destRect     = CenterRect(imageRect   ,windowRect);
if disp_param.target_fix,
	imageFRect    = SetRect(0,0,size(disp_param.fixation,1),size(disp_param.fixation,2));
	destFRect     = CenterRect(imageFRect   ,windowRect);
end;

SCREEN(whichScreen,'Preference','SetClutDriverWaitsForBlanking',1);%default is 1 but just in case

%----------------------------------------------------------
% Put images into offscreen memory.
%----------------------------------------------------------
for n=1:size(disp_param.stimulus,3),
	ow(n)=SCREEN(window,'OpenOffscreenWindow',0,imageRect,8);
	SCREEN(ow(n),'PutImage',disp_param.stimulus(:,:,n),imageRect);
end;
if disp_param.target_fix,
	for n=1:2,
		owf(n)=SCREEN(window,'OpenOffscreenWindow',0,imageFRect,8);
		SCREEN(owf(n),'PutImage',disp_param.fixation(:,:,n),imageFRect);
	end;
end;

disp(sprintf('Each loop should last %d frames (%.4f secs)',disp_param.nframes*128,...
              round(1/stim_param.tempfreq * disp_param.framerate) / disp_param.framerate * 128));

			  
%----------------------------------------------------------
%--- some used parameters
%----------------------------------------------------------
sync_param.response = zeros(1000,1); % large so matlab has allocated enough memory
sync_param.resptime = sync_param.response;
sync_param.quit     = double(fmri_param.qbutton);
sync_param.trigger  = double(fmri_param.tbutton);
sync_param.vblcount = 1;

QUIT=0;
TRIG=0;
index=0;
vblframe=0;
VBL=1/stim_param.tempfreq;
VBL_STEP=fmri_param.tr/fmri_param.spf;
MAX_VBL_STEP=length(fmri_param.stimseq);
myvblstep=1;
randval=0;
repclut=0;
target=1;
TIME=0;
starttime=0;

%----------------------------------------------------------
%--- exp. loop
%----------------------------------------------------------
clutstring=[];
if stim_param.fixstim==0,
	clutstring=['clut=[[disp_param.meanlum; 255; 0;]*ones(1,3); round(rand(253,3)*255)];'];
else,
	clutstring=[clutstring 'if(fmri_param.fixseq(TRIG)==0),'];
	clutstring=[clutstring    'clut=[[disp_param.meanlum; 255; 0;]*ones(1,3); round(rand(253,3)*255)];'];
    clutstring=[clutstring 'else,'];
	clutstring=[clutstring    'clut=[[disp_param.meanlum; round(rand(2,1))*255]*ones(1,3); round(rand(253,3)*255)];'];
    clutstring=[clutstring 'end;'];
end;
if arg_param.runpsych,
	trigstring = ['if(TIME > VBL_STEP),']; %% keep going
else,
	trigstring = ['if(TIME > VBL_STEP & myvblstep < fmri_param.spf),']; %% MR waits for trigger
end;

loop ={
% 'SCREEN(window,''PeekBlanking'');' %--- prep and load trigger
 'FlushEvents(''keyDown'');'
 'SCREEN(''CopyWindow'', ow(5), window,imageRect,destRect);'
 'SCREEN(window,''SetClut'',disp_param.zclut);'
 'while(index==0),'
	'if(charavail),'
		'index=getchar;'
		'TIME=getsecs;'
		'index=1;'
	'end;'
 'end;'
 'SCREEN(''CopyWindow'', ow(1), window,imageRect,destRect);'
 'SCREEN(window,''SetClut'',disp_param.gclut);'
 
 'while(1),'
 	'if charavail,'
 		'sync_param.response(index)=double(getchar);'
		'if(sync_param.response(index)==sync_param.trigger),'
			'sync_param.resptime(index)=getsecs;'
 			'starttime=sync_param.resptime(index);'
			'TRIG=TRIG+1;'
			'index=index+1;'
			'break;'
		'elseif(sync_param.response(index)==sync_param.quit),'
			'QUIT=1;'
			'break;'
		'end;'
	'end;'
	'button=0;'
	'[x,y,button]=GetMouse(disp_param.whichscreen);'
	'if button,'
		'sync_param.resptime(index)=getsecs;'
 		'starttime=sync_param.resptime(index);'
		'TRIG=TRIG+1;'
		'index=index+1;'
		'waitforbuttontogooff=1;' % wait for button to go off (unpressed)
		'break;'
	'end;'
 'end;'
 'while TRIG<fmri_param.ntimeframes,'
	'TIME=(getsecs-starttime);'
	trigstring
		'SCREEN(''CopyWindow'',ow(fmri_param.stimseq(TRIG*fmri_param.spf-fmri_param.spf+1+myvblstep)),window,imageRect,destRect);'
		'if(repclut~=0 & disp_param.target_fix),'
			'SCREEN(''CopyWindow'',owf(target),window,imageFRect,destFRect);'
		'end;'
		'VBL_STEP=VBL_STEP+fmri_param.tr/fmri_param.spf;'
		'if(TRIG*fmri_param.spf-fmri_param.spf+1+myvblstep)>=MAX_VBL_STEP,break;end;'
		'myvblstep=myvblstep+1;'
		'sync_param.response(index)=2;'
		'sync_param.resptime(index)=getsecs;'
		'index=index+1;'
	'end;'	
	'if(TIME > VBL),'
	    clutstring 
		'if(repclut==0),'
			'if rand<fmri_param.taskthresh,'
				'if disp_param.target_fix,'
					'target=round(rand)+1;'
					'SCREEN(''CopyWindow'',owf(target),window,imageFRect,destFRect);'
				'else,'
					'target=round(rand*2)+1;'
					'randval=round(rand*(disp_param.target_rows-1))+1;'
					'clut(disp_param.target_rows_index(randval,:),:)=disp_param.target(:,:,target);'
				'end;'
				'sync_param.resptime(index)=getsecs;'
				'sync_param.response(index)=1;'
				'repclut=1;'
				'index=index+1;'
			'else,'
				'if disp_param.target_fix,'
					'SCREEN(''CopyWindow'',ow(fmri_param.stimseq(TRIG*fmri_param.spf-fmri_param.spf+1+myvblstep-1)),window,imageRect,destRect);'
				'end;'
			'end;'
		'else,'
			'if(repclut>=disp_param.target_duration),'
				'repclut=0;'
			'else,'
				'if ~disp_param.target_fix,'
					'target=(target-3.5)*-1+3.5;'
					'clut(disp_param.target_rows_index(randval,:),:)=disp_param.target(:,:,target);'
				'end;'
				'repclut=repclut+1;'
			'end;'
		'end;'
		'SCREEN(window,''SetClut'',clut);'
		'VBL=VBL+1/stim_param.tempfreq;'
	'end;'
	% hack to sync to mouse clicks
	'[x,y,button]=GetMouse(disp_param.whichscreen);'
	'if ~button,'
		'waitforbuttontogooff=0;'
	'end;'
	'if (button & ~waitforbuttontogooff),'
		'TRIG=TRIG+1;'
		'myvblstep=1;'
		'SCREEN(''CopyWindow'',ow(fmri_param.owtrig(TRIG)),window,imageRect,destRect);'
		'if(repclut~=0 & disp_param.target_fix),'
			'SCREEN(''CopyWindow'',owf(target),window,imageFRect,destFRect);'
		'end;'
		'VBL_STEP=TIME+fmri_param.tr/fmri_param.spf;'
		'index=index+1;'
		'waitforbuttontogooff=1;';
	'end;'
	% sync to character
	'while(charavail),'
		'sync_param.response(index)=double(getchar);'
		'sync_param.resptime(index)=getsecs;'
		'if(sync_param.response(index)==sync_param.quit),'
			'QUIT=1;'
			'index=index+1;'
		'elseif(sync_param.response(index)==sync_param.trigger),'
			'TRIG=TRIG+1;'
			'myvblstep=1;'
			'SCREEN(''CopyWindow'',ow(fmri_param.owtrig(TRIG)),window,imageRect,destRect);'
			'if(repclut~=0 & disp_param.target_fix),'
				'SCREEN(''CopyWindow'',owf(target),window,imageFRect,destFRect);'
			'end;'
			'VBL_STEP=TIME+fmri_param.tr/fmri_param.spf;'
			'index=index+1;'
		'else,'
			'if disp_param.target_fix & disp_param.target_fixdiscim,'
				'if target==1 & sync_param.response(index)==double(fmri_param.rbutton(1)),'
					'repclut=0;'
					'index=index+1;'
				'elseif target==2 & sync_param.response(index)==double(fmri_param.rbutton(3)),'
					'repclut=0;'
					'index=index+1;'
				'end;'
			'else,'
				'repclut=0;'
				'index=index+1;'
			'end;'
		'end;'
	'end;'
	% sync to button
	'while(charavail),'
		'sync_param.response(index)=double(getchar);'
		'sync_param.resptime(index)=getsecs;'
		'if(sync_param.response(index)==sync_param.quit),'
			'QUIT=1;'
			'index=index+1;'
		'elseif(sync_param.response(index)==sync_param.trigger),'
			'TRIG=TRIG+1;'
			'myvblstep=1;'
			'SCREEN(''CopyWindow'',ow(fmri_param.owtrig(TRIG)),window,imageRect,destRect);'
			'if(repclut~=0 & disp_param.target_fix),'
				'SCREEN(''CopyWindow'',owf(target),window,imageFRect,destFRect);'
			'end;'
			'VBL_STEP=TIME+fmri_param.tr/fmri_param.spf;'
			'index=index+1;'
		'else,'
			'if disp_param.target_fix & disp_param.target_fixdiscim,'
				'if target==1 & sync_param.response(index)==double(fmri_param.rbutton(1)),'
					'repclut=0;'
					'index=index+1;'
				'elseif target==2 & sync_param.response(index)==double(fmri_param.rbutton(3)),'
					'repclut=0;'
					'index=index+1;'
				'end;'
			'else,'
				'repclut=0;'
				'index=index+1;'
			'end;'
		'end;'
	'end;'
	'if(QUIT),break;end;'
 'end;'
 'disp(sprintf(''Elapsed time: %.1f secs.'',GetSecs-sync_param.resptime(1)));'
};

SCREEN('Screens');GetSecs;CharAvail; % Make sure all Rushed functions are in memory.
	
%----------------------------------------------------------
%--- run
%----------------------------------------------------------
hidecursor;
Rush(loop,priorityLevel);
showcursor;

%----------------------------------------------------------
%--- Close up
%----------------------------------------------------------
SCREEN('closeall');
clear mex;	

%----------------------------------------------------------
%--- output
%----------------------------------------------------------
index=find(sync_param.response==0);
index=index(1);
sync_param.response=sync_param.response(1:index-1);
sync_param.resptime=sync_param.resptime(1:index-1)-sync_param.resptime(1);
sync_param.charresp=char(sync_param.response);

